CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1                  
				FROM 
					information_schema.columns     
                WHERE 
					table_name ilike ('PDV_VD_ORC')
					and column_name ilike ('TP_ORC_ENTG')
	) THEN
         RAISE NOTICE 'Coluna  TP_ORC_ENTG  na tabela  PDV_VD_ORC  ja existe!' ;
    ELSE
		ALTER TABLE PDV_VD_ORC add TP_ORC_ENTG numeric default 0;
        RAISE NOTICE 'Coluna "TP_ORC_ENTG" criada com sucesso!';
    END IF;     
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();

